<?php
/*--------------------------------------------------------------------------------------------------
    OnSellingUnitIdCreateListener.php 2020-02-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Product\SellingUnit\Database\Listener;

use Exception;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\SellingUnit\Unit\Events\Interfaces\OnSellingUnitIdCreateEventInterface;

class OnSellingUnitIdCreateListener
{
    /**
     * @param OnSellingUnitIdCreateEventInterface $event
     *
     * @return OnSellingUnitIdCreateEventInterface
     * @throws Exception
     */
    public function __invoke(OnSellingUnitIdCreateEventInterface $event): OnSellingUnitIdCreateEventInterface
    {
        $combinationId = 0;
        
        if ($event->type() === 'product' || $event->type() === 'product_id') {
            $event->builder()->withProductId(new ProductId((int)$event->value()));
        } elseif ($event->type() === 'info') {
            preg_match("/p([\d]+)(?:\{[\d]+\}[\d]+)*(?:x[\d]+){0,1}_/", $event->value(), $t_extract);
            if (isset($t_extract[1])) {
                $event->builder()->withProductId(new ProductId((int)$t_extract[1]));
            }
        }
        
        return $event;
    }
    
}